using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    const long INF_DIST = long.MaxValue;

    public class JarbolData
    {
        public int OriginalIndex { get; set; }
        public long X { get; set; }
        public long H { get; set; }
        public long BestDistance { get; set; } = INF_DIST;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x_input = Console.ReadLine().Split().Select(long.Parse).ToArray();
        long[] h_input = Console.ReadLine().Split().Select(long.Parse).ToArray();

        List<JarbolData> jarboli = new List<JarbolData>();
        for (int i = 0; i < n; i++)
        {
            jarboli.Add(new JarbolData { OriginalIndex = i, X = x_input[i], H = h_input[i] });
        }

        var sortedJarboli = jarboli.OrderBy(p => p.X).ToList();

        // Algoritam pronalazenja prvog viseg elementa levo/desno.
        // I dalje koristimo O(N^2) logiku jer je jednostavnija za implementaciju.
        for (int i = 0; i < n; i++)
        {
            // Provera levo: Pronadji prvi visi element J sa leve strane
            for (int j = i - 1; j >= 0; j--)
            {
                if (sortedJarboli[j].H >= sortedJarboli[i].H)
                {
                    // Razdaljina je razlika X koordinata. Y koordinate se podrazumevano poklapaju 
                    // na vrhu manjeg jarbola u ovom slucaju.
                    long dist = sortedJarboli[i].X - sortedJarboli[j].X;
                    sortedJarboli[i].BestDistance = Math.Min(sortedJarboli[i].BestDistance, dist);
                    break;
                }
            }
            // Provera desno: Pronadji prvi visi element J sa desne strane
            for (int j = i + 1; j < n; j++)
            {
                if (sortedJarboli[j].H >= sortedJarboli[i].H)
                {
                    long dist = sortedJarboli[j].X - sortedJarboli[i].X;
                    sortedJarboli[i].BestDistance = Math.Min(sortedJarboli[i].BestDistance, dist);
                    break;
                }
            }
        }
        
        // Vracamo rezultate u originalni redosled
        long[] output = new long[n];
        foreach (var jarbol in sortedJarboli)
        {
            if (jarbol.BestDistance >= INF_DIST)
            {
                output[jarbol.OriginalIndex] = -1; // Nema viseg dela
            }
            else
            {
                output[jarbol.OriginalIndex] = jarbol.BestDistance;
            }
        }

        // Ispis rezultata
        foreach (long res in output)
        {
            Console.WriteLine(res);
        }
    }
}